/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.cim;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.snia.wbemcmd.xml.Authorizer;

public class CimAuthorization
implements Authorizer {
    public static final String CIMOM_PATH = "cimom";
    public static final String MANAGER_USER = "_MANAGER_";
    public static final String MANAGER_PASSWORD_FILE = "managerpw";
    private static String passwordFilePath = null;
    private static InheritableThreadLocal THREAD_LOCAL = new InheritableThreadLocal();
    private static final String TRACE_MASKT = "XCIMATHT";
    private static final String TRACE_MASKF = "XCIMATHF";
    private static final String TRACE_MASKD = "XCIMATHD";

    public void init() {
        try {
            String cimomPath = BaseFileControl.getFilePath(CIMOM_PATH);
            passwordFilePath = cimomPath + File.separator + MANAGER_PASSWORD_FILE;
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<> init()");
    }

    public boolean authenticate(String userName, String password) {
        Trace.trace(TRACE_MASKT, "-> authenticate(userName=" + userName + ")");
        boolean result = false;
        if (userName.equals(MANAGER_USER) && passwordFilePath != null) {
            try {
                File passwordFile = new File(passwordFilePath);
                result = passwordFile.canRead();
                if (result) {
                    int fileSize = (int)passwordFile.length();
                    char[] fileContents = new char[fileSize];
                    FileInputStream stream = new FileInputStream(passwordFile);
                    InputStreamReader reader = new InputStreamReader(stream);
                    reader.read(fileContents, 0, fileSize);
                    reader.close();
                    result = password.equals(new String(fileContents));
                }
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        } else {
            User user = User.getUser(userName);
            if (user != null) {
                result = user.isPasswordValid(password);
            }
        }
        if (result) {
            int type = 2;
            if (userName.equals(MANAGER_USER)) {
                type = 3;
            }
            UserContext context = new UserContext(userName, null, type, null);
            THREAD_LOCAL.set(context);
        }
        Trace.trace(TRACE_MASKT, "<- authenticate(returns " + result + ")");
        return result;
    }

    public boolean optionsRequireLogin() {
        return false;
    }

    public boolean allowAnonymous() {
        return false;
    }

    public boolean accessCheckEnabled() {
        return false;
    }

    public void executeChecked(Runnable r) {
        r.run();
    }
}

